/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class WeatherParticle
extends TextureSheetParticle {
    protected BlockPos.MutableBlockPos pos;
    boolean shouldFadeOut = false;
    float temperature;

    protected WeatherParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.f_107225_ = ParticleRainClient.config.particleRadius * 10;
        this.f_107230_ = 0.0f;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.temperature = ((Biome)level.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_();
        ++ParticleRainClient.particleCount;
    }

    public void m_5989_() {
        super.m_5989_();
        this.pos.m_122169_(this.f_107212_, this.f_107213_ - 0.2, this.f_107214_);
        this.removeIfOOB();
        if (this.shouldFadeOut) {
            this.fadeOut();
        } else if (this.f_107224_ % 10 == 0) {
            if ((double)Mth.m_14154_((float)(((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_() - this.temperature)) > 0.4) {
                this.shouldFadeOut = true;
            }
        } else {
            this.fadeIn();
        }
    }

    public void fadeIn() {
        if (this.f_107224_ < 20) {
            this.f_107230_ = (float)this.f_107224_ * 1.0f / 20.0f;
        }
    }

    public void fadeOut() {
        if ((double)this.f_107230_ < 0.01) {
            this.m_107274_();
        } else {
            this.f_107230_ -= 0.05f;
        }
    }

    public void m_107274_() {
        if (this.m_107276_()) {
            --ParticleRainClient.particleCount;
        }
        super.m_107274_();
    }

    void removeIfOOB() {
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity == null || cameraEntity.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_) > (double)Mth.m_144944_((int)ParticleRainClient.config.particleRadius)) {
            this.shouldFadeOut = true;
        }
    }

    protected boolean removeIfObstructed() {
        if (this.f_107212_ == this.f_107209_ || this.f_107214_ == this.f_107211_) {
            this.m_107274_();
            return true;
        }
        return false;
    }

    public Quaternionf flipItTurnwaysIfBackfaced(Quaternionf quaternion, Vector3f toCamera) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)toCamera);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_((float)Math.PI));
        }
        return quaternion;
    }

    public void renderRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternion, float x, float y, float z, float tickPercentage) {
        quaternion.rotateY((float)Math.PI);
        float quadSize = this.m_5902_(tickPercentage);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int lightColor = this.m_6355_(tickPercentage);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f = vector3fs[k];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(quadSize);
            vector3f.add(x, y, z);
        }
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(lightColor).m_5752_();
    }
}

